package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  MetricsId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBucketMetricsConfigurationRequest(
    bucket: BucketName,
    id: MetricsId,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest = {
    import DeleteBucketMetricsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketMetricsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest(
        bucketValue,
        idValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: MetricsId
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(idValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: MetricsId = impl.id(): MetricsId
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteBucketMetricsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
