package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBucketWebsiteRequest(
    bucket: BucketName,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest = {
    import DeleteBucketWebsiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest
      .wrap(buildAwsValue())
}
object DeleteBucketWebsiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest =
      io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest(
        bucketValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteBucketWebsiteRequest.ReadOnly =
    new Wrapper(impl)
}
