package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  LastModified,
  IsLatest,
  ObjectVersionId,
  ObjectKey
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteMarkerEntry(
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None,
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    isLatest: Option[IsLatest] = None,
    lastModified: Option[LastModified] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteMarkerEntry = {
    import DeleteMarkerEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(isLatest.map(value => value: java.lang.Boolean))(
        _.isLatest
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.wrap(buildAwsValue())
}
object DeleteMarkerEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry =
      io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry(
        ownerValue.map(value => value.editable),
        keyValue.map(value => value),
        versionIdValue.map(value => value),
        isLatestValue.map(value => value),
        lastModifiedValue.map(value => value)
      )
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def keyValue: Option[ObjectKey]
    def versionIdValue: Option[ObjectVersionId]
    def isLatestValue: Option[IsLatest]
    def lastModifiedValue: Option[LastModified]
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def isLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatestValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ) extends io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly {
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def isLatestValue: Option[IsLatest] =
      scala.Option(impl.isLatest()).map(value => value: IsLatest)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerEntry
  ): io.github.vigoo.zioaws.s3.model.DeleteMarkerEntry.ReadOnly = new Wrapper(
    impl
  )
}
