package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteMarkerReplication(
    status: Option[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplicationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteMarkerReplication = {
    import DeleteMarkerReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication
      .wrap(buildAwsValue())
}
object DeleteMarkerReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication =
      io.github.vigoo.zioaws.s3.model
        .DeleteMarkerReplication(statusValue.map(value => value))
    def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.DeleteMarkerReplicationStatus]
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplicationStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ) extends io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly {
    override def statusValue: Option[
      io.github.vigoo.zioaws.s3.model.DeleteMarkerReplicationStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.DeleteMarkerReplicationStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteMarkerReplication
  ): io.github.vigoo.zioaws.s3.model.DeleteMarkerReplication.ReadOnly =
    new Wrapper(impl)
}
