package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  BypassGovernanceRetention,
  MFA,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteObjectRequest(
    bucket: BucketName,
    key: ObjectKey,
    mfa: Option[MFA] = None,
    versionId: Option[ObjectVersionId] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(mfa.map(value => value: java.lang.String))(_.mfa)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteObjectRequest =
      io.github.vigoo.zioaws.s3.model.DeleteObjectRequest(
        bucketValue,
        keyValue,
        mfaValue.map(value => value),
        versionIdValue.map(value => value),
        requestPayerValue.map(value => value),
        bypassGovernanceRetentionValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def mfaValue: Option[MFA]
    def versionIdValue: Option[ObjectVersionId]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def bypassGovernanceRetentionValue: Option[BypassGovernanceRetention]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def mfa: ZIO[Any, AwsError, MFA] =
      AwsError.unwrapOptionField("mfa", mfaValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def bypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] =
      AwsError.unwrapOptionField(
        "bypassGovernanceRetention",
        bypassGovernanceRetentionValue
      )
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteObjectRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def mfaValue: Option[MFA] =
      scala.Option(impl.mfa()).map(value => value: MFA)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def bypassGovernanceRetentionValue
        : Option[BypassGovernanceRetention] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: BypassGovernanceRetention)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
