package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ObjectVersionId,
  DeleteMarker
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteObjectResponse(
    deleteMarker: Option[DeleteMarker] = None,
    versionId: Option[ObjectVersionId] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectResponse = {
    import DeleteObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectResponse
      .builder()
      .optionallyWith(deleteMarker.map(value => value: java.lang.Boolean))(
        _.deleteMarker
      )
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.wrap(buildAwsValue())
}
object DeleteObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteObjectResponse =
      io.github.vigoo.zioaws.s3.model.DeleteObjectResponse(
        deleteMarkerValue.map(value => value),
        versionIdValue.map(value => value),
        requestChargedValue.map(value => value)
      )
    def deleteMarkerValue: Option[DeleteMarker]
    def versionIdValue: Option[ObjectVersionId]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def deleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarkerValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ) extends io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly {
    override def deleteMarkerValue: Option[DeleteMarker] =
      scala.Option(impl.deleteMarker()).map(value => value: DeleteMarker)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectResponse
  ): io.github.vigoo.zioaws.s3.model.DeleteObjectResponse.ReadOnly =
    new Wrapper(impl)
}
