package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ObjectVersionId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteObjectTaggingRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest = {
    import DeleteObjectTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest
      .wrap(buildAwsValue())
}
object DeleteObjectTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest =
      io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest(
        bucketValue,
        keyValue,
        versionIdValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def versionIdValue: Option[ObjectVersionId]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteObjectTaggingRequest.ReadOnly =
    new Wrapper(impl)
}
