package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  BypassGovernanceRetention,
  MFA,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteObjectsRequest(
    bucket: BucketName,
    delete: io.github.vigoo.zioaws.s3.model.Delete,
    mfa: Option[MFA] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    expectedBucketOwner: Option[AccountId] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectsRequest = {
    import DeleteObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .delete(delete.buildAwsValue())
      .optionallyWith(mfa.map(value => value: java.lang.String))(_.mfa)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest.wrap(buildAwsValue())
}
object DeleteObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest =
      io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest(
        bucketValue,
        deleteValue.editable,
        mfaValue.map(value => value),
        requestPayerValue.map(value => value),
        bypassGovernanceRetentionValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        checksumAlgorithmValue.map(value => value)
      )
    def bucketValue: BucketName
    def deleteValue: io.github.vigoo.zioaws.s3.model.Delete.ReadOnly
    def mfaValue: Option[MFA]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def bypassGovernanceRetentionValue: Option[BypassGovernanceRetention]
    def expectedBucketOwnerValue: Option[AccountId]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def delete
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Delete.ReadOnly] =
      ZIO.succeed(deleteValue)
    def mfa: ZIO[Any, AwsError, MFA] =
      AwsError.unwrapOptionField("mfa", mfaValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def bypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] =
      AwsError.unwrapOptionField(
        "bypassGovernanceRetention",
        bypassGovernanceRetentionValue
      )
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def deleteValue: io.github.vigoo.zioaws.s3.model.Delete.ReadOnly =
      io.github.vigoo.zioaws.s3.model.Delete.wrap(impl.delete())
    override def mfaValue: Option[MFA] =
      scala.Option(impl.mfa()).map(value => value: MFA)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def bypassGovernanceRetentionValue
        : Option[BypassGovernanceRetention] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: BypassGovernanceRetention)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteObjectsRequest.ReadOnly =
    new Wrapper(impl)
}
