package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteObjectsResponse(
    deleted: Option[Iterable[io.github.vigoo.zioaws.s3.model.DeletedObject]] =
      None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    errors: Option[Iterable[io.github.vigoo.zioaws.s3.model.S3Error]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectsResponse = {
    import DeleteObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
      .builder()
      .optionallyWith(
        deleted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleted)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.wrap(buildAwsValue())
}
object DeleteObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse =
      io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse(
        deletedValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        requestChargedValue.map(value => value),
        errorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def deletedValue
        : Option[List[io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly]]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def errorsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly]]
    def deleted: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly
    ]] = AwsError.unwrapOptionField("deleted", deletedValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def errors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errorsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ) extends io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.ReadOnly {
    override def deletedValue
        : Option[List[io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly]] =
      scala
        .Option(impl.deleted())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.DeletedObject.wrap(item)
          }.toList
        )
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def errorsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.S3Error.ReadOnly]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.S3Error.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsResponse
  ): io.github.vigoo.zioaws.s3.model.DeleteObjectsResponse.ReadOnly =
    new Wrapper(impl)
}
