package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  DeleteMarkerVersionId,
  DeleteMarker,
  ObjectVersionId,
  ObjectKey
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeletedObject(
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    deleteMarker: Option[DeleteMarker] = None,
    deleteMarkerVersionId: Option[DeleteMarkerVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeletedObject = {
    import DeletedObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeletedObject
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(deleteMarker.map(value => value: java.lang.Boolean))(
        _.deleteMarker
      )
      .optionallyWith(
        deleteMarkerVersionId.map(value => value: java.lang.String)
      )(_.deleteMarkerVersionId)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeletedObject.wrap(buildAwsValue())
}
object DeletedObject {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.DeletedObject] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DeletedObject =
      io.github.vigoo.zioaws.s3.model.DeletedObject(
        keyValue.map(value => value),
        versionIdValue.map(value => value),
        deleteMarkerValue.map(value => value),
        deleteMarkerVersionIdValue.map(value => value)
      )
    def keyValue: Option[ObjectKey]
    def versionIdValue: Option[ObjectVersionId]
    def deleteMarkerValue: Option[DeleteMarker]
    def deleteMarkerVersionIdValue: Option[DeleteMarkerVersionId]
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def deleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarkerValue)
    def deleteMarkerVersionId: ZIO[Any, AwsError, DeleteMarkerVersionId] =
      AwsError.unwrapOptionField(
        "deleteMarkerVersionId",
        deleteMarkerVersionIdValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeletedObject
  ) extends io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly {
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def deleteMarkerValue: Option[DeleteMarker] =
      scala.Option(impl.deleteMarker()).map(value => value: DeleteMarker)
    override def deleteMarkerVersionIdValue: Option[DeleteMarkerVersionId] =
      scala
        .Option(impl.deleteMarkerVersionId())
        .map(value => value: DeleteMarkerVersionId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeletedObject
  ): io.github.vigoo.zioaws.s3.model.DeletedObject.ReadOnly = new Wrapper(impl)
}
