package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Destination(
    bucket: BucketName,
    account: Option[AccountId] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    accessControlTranslation: Option[
      io.github.vigoo.zioaws.s3.model.AccessControlTranslation
    ] = None,
    encryptionConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.EncryptionConfiguration
    ] = None,
    replicationTime: Option[io.github.vigoo.zioaws.s3.model.ReplicationTime] =
      None,
    metrics: Option[io.github.vigoo.zioaws.s3.model.Metrics] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Destination
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        accessControlTranslation.map(value => value.buildAwsValue())
      )(_.accessControlTranslation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(replicationTime.map(value => value.buildAwsValue()))(
        _.replicationTime
      )
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Destination.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Destination =
      io.github.vigoo.zioaws.s3.model.Destination(
        bucketValue,
        accountValue.map(value => value),
        storageClassValue.map(value => value),
        accessControlTranslationValue.map(value => value.editable),
        encryptionConfigurationValue.map(value => value.editable),
        replicationTimeValue.map(value => value.editable),
        metricsValue.map(value => value.editable)
      )
    def bucketValue: BucketName
    def accountValue: Option[AccountId]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def accessControlTranslationValue: Option[
      io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly
    ]
    def encryptionConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly
    ]
    def replicationTimeValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly]
    def metricsValue: Option[io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def account: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("account", accountValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def accessControlTranslation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlTranslation",
      accessControlTranslationValue
    )
    def encryptionConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfigurationValue
    )
    def replicationTime: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTime", replicationTimeValue)
    def metrics
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly] =
      AwsError.unwrapOptionField("metrics", metricsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Destination
  ) extends io.github.vigoo.zioaws.s3.model.Destination.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def accountValue: Option[AccountId] =
      scala.Option(impl.account()).map(value => value: AccountId)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def accessControlTranslationValue: Option[
      io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly
    ] = scala
      .Option(impl.accessControlTranslation())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.AccessControlTranslation.wrap(value)
      )
    override def encryptionConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.encryptionConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.wrap(value)
      )
    override def replicationTimeValue
        : Option[io.github.vigoo.zioaws.s3.model.ReplicationTime.ReadOnly] =
      scala
        .Option(impl.replicationTime())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ReplicationTime.wrap(value)
        )
    override def metricsValue
        : Option[io.github.vigoo.zioaws.s3.model.Metrics.ReadOnly] = scala
      .Option(impl.metrics())
      .map(value => io.github.vigoo.zioaws.s3.model.Metrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Destination
  ): io.github.vigoo.zioaws.s3.model.Destination.ReadOnly = new Wrapper(impl)
}
