package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait EncodingType {
  def unwrap: software.amazon.awssdk.services.s3.model.EncodingType
}
object EncodingType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.EncodingType
  ): io.github.vigoo.zioaws.s3.model.EncodingType = value match {
    case software.amazon.awssdk.services.s3.model.EncodingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.EncodingType.URL =>
      val r = url
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.EncodingType {
    override def unwrap: software.amazon.awssdk.services.s3.model.EncodingType =
      software.amazon.awssdk.services.s3.model.EncodingType.UNKNOWN_TO_SDK_VERSION
  }
  case object url extends io.github.vigoo.zioaws.s3.model.EncodingType {
    override def unwrap: software.amazon.awssdk.services.s3.model.EncodingType =
      software.amazon.awssdk.services.s3.model.EncodingType.URL
  }
}
