package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{KMSContext, SSEKMSKeyId}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Encryption(
    encryptionType: io.github.vigoo.zioaws.s3.model.ServerSideEncryption,
    kmsKeyId: Option[SSEKMSKeyId] = None,
    kmsContext: Option[KMSContext] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Encryption = {
    import Encryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Encryption
      .builder()
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kmsContext.map(value => value: java.lang.String))(
        _.kmsContext
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Encryption.wrap(buildAwsValue())
}
object Encryption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Encryption] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Encryption =
      io.github.vigoo.zioaws.s3.model.Encryption(
        encryptionTypeValue,
        kmsKeyIdValue.map(value => value),
        kmsContextValue.map(value => value)
      )
    def encryptionTypeValue
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    def kmsKeyIdValue: Option[SSEKMSKeyId]
    def kmsContextValue: Option[KMSContext]
    def encryptionType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = ZIO.succeed(encryptionTypeValue)
    def kmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def kmsContext: ZIO[Any, AwsError, KMSContext] =
      AwsError.unwrapOptionField("kmsContext", kmsContextValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Encryption
  ) extends io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly {
    override def encryptionTypeValue
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryption =
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
        .wrap(impl.encryptionType())
    override def kmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.kmsKeyId()).map(value => value: SSEKMSKeyId)
    override def kmsContextValue: Option[KMSContext] =
      scala.Option(impl.kmsContext()).map(value => value: KMSContext)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Encryption
  ): io.github.vigoo.zioaws.s3.model.Encryption.ReadOnly = new Wrapper(impl)
}
