package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.ReplicaKmsKeyID
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncryptionConfiguration(
    replicaKmsKeyID: Option[ReplicaKmsKeyID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.EncryptionConfiguration
      .builder()
      .optionallyWith(replicaKmsKeyID.map(value => value: java.lang.String))(
        _.replicaKmsKeyID
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.EncryptionConfiguration
      .wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.EncryptionConfiguration =
      io.github.vigoo.zioaws.s3.model
        .EncryptionConfiguration(replicaKmsKeyIDValue.map(value => value))
    def replicaKmsKeyIDValue: Option[ReplicaKmsKeyID]
    def replicaKmsKeyID: ZIO[Any, AwsError, ReplicaKmsKeyID] =
      AwsError.unwrapOptionField("replicaKmsKeyID", replicaKmsKeyIDValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly {
    override def replicaKmsKeyIDValue: Option[ReplicaKmsKeyID] =
      scala.Option(impl.replicaKmsKeyID()).map(value => value: ReplicaKmsKeyID)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.EncryptionConfiguration
  ): io.github.vigoo.zioaws.s3.model.EncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
