package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.ObjectKey
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ErrorDocument(key: ObjectKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ErrorDocument = {
    import ErrorDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ErrorDocument
      .builder()
      .key(key: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ErrorDocument.wrap(buildAwsValue())
}
object ErrorDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ErrorDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ErrorDocument =
      io.github.vigoo.zioaws.s3.model.ErrorDocument(keyValue)
    def keyValue: ObjectKey
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ErrorDocument
  ) extends io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly {
    override def keyValue: ObjectKey = impl.key(): ObjectKey
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ErrorDocument
  ): io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly = new Wrapper(impl)
}
