package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExistingObjectReplication(
    status: io.github.vigoo.zioaws.s3.model.ExistingObjectReplicationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ExistingObjectReplication = {
    import ExistingObjectReplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ExistingObjectReplication
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ExistingObjectReplication
      .wrap(buildAwsValue())
}
object ExistingObjectReplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ExistingObjectReplication =
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplication(statusValue)
    def statusValue
        : io.github.vigoo.zioaws.s3.model.ExistingObjectReplicationStatus
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplicationStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ) extends io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly {
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.ExistingObjectReplicationStatus =
      io.github.vigoo.zioaws.s3.model.ExistingObjectReplicationStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ExistingObjectReplication
  ): io.github.vigoo.zioaws.s3.model.ExistingObjectReplication.ReadOnly =
    new Wrapper(impl)
}
