package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ExpirationStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.ExpirationStatus
}
object ExpirationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ExpirationStatus
  ): io.github.vigoo.zioaws.s3.model.ExpirationStatus = value match {
    case software.amazon.awssdk.services.s3.model.ExpirationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ExpirationStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.ExpirationStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExpirationStatus =
      software.amazon.awssdk.services.s3.model.ExpirationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends io.github.vigoo.zioaws.s3.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExpirationStatus =
      software.amazon.awssdk.services.s3.model.ExpirationStatus.ENABLED
  }
  case object Disabled
      extends io.github.vigoo.zioaws.s3.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExpirationStatus =
      software.amazon.awssdk.services.s3.model.ExpirationStatus.DISABLED
  }
}
