package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ExpressionType {
  def unwrap: software.amazon.awssdk.services.s3.model.ExpressionType
}
object ExpressionType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ExpressionType
  ): io.github.vigoo.zioaws.s3.model.ExpressionType = value match {
    case software.amazon.awssdk.services.s3.model.ExpressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ExpressionType.SQL =>
      val r = SQL
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExpressionType =
      software.amazon.awssdk.services.s3.model.ExpressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SQL extends io.github.vigoo.zioaws.s3.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExpressionType =
      software.amazon.awssdk.services.s3.model.ExpressionType.SQL
  }
}
