package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait FileHeaderInfo {
  def unwrap: software.amazon.awssdk.services.s3.model.FileHeaderInfo
}
object FileHeaderInfo {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.FileHeaderInfo
  ): io.github.vigoo.zioaws.s3.model.FileHeaderInfo = value match {
    case software.amazon.awssdk.services.s3.model.FileHeaderInfo.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.FileHeaderInfo.USE =>
      val r = USE
      r
    case software.amazon.awssdk.services.s3.model.FileHeaderInfo.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.s3.model.FileHeaderInfo.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.FileHeaderInfo {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FileHeaderInfo =
      software.amazon.awssdk.services.s3.model.FileHeaderInfo.UNKNOWN_TO_SDK_VERSION
  }
  case object USE extends io.github.vigoo.zioaws.s3.model.FileHeaderInfo {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FileHeaderInfo =
      software.amazon.awssdk.services.s3.model.FileHeaderInfo.USE
  }
  case object IGNORE extends io.github.vigoo.zioaws.s3.model.FileHeaderInfo {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FileHeaderInfo =
      software.amazon.awssdk.services.s3.model.FileHeaderInfo.IGNORE
  }
  case object NONE extends io.github.vigoo.zioaws.s3.model.FileHeaderInfo {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FileHeaderInfo =
      software.amazon.awssdk.services.s3.model.FileHeaderInfo.NONE
  }
}
