package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.FilterRuleValue
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FilterRule(
    name: Option[io.github.vigoo.zioaws.s3.model.FilterRuleName] = None,
    value: Option[FilterRuleValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.FilterRule = {
    import FilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.FilterRule
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.FilterRule.wrap(buildAwsValue())
}
object FilterRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.FilterRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.FilterRule =
      io.github.vigoo.zioaws.s3.model.FilterRule(
        nameValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[io.github.vigoo.zioaws.s3.model.FilterRuleName]
    def valueValue: Option[FilterRuleValue]
    def name
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.FilterRuleName] =
      AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, FilterRuleValue] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.FilterRule
  ) extends io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly {
    override def nameValue
        : Option[io.github.vigoo.zioaws.s3.model.FilterRuleName] = scala
      .Option(impl.name())
      .map(value => io.github.vigoo.zioaws.s3.model.FilterRuleName.wrap(value))
    override def valueValue: Option[FilterRuleValue] =
      scala.Option(impl.value()).map(value => value: FilterRuleValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.FilterRule
  ): io.github.vigoo.zioaws.s3.model.FilterRule.ReadOnly = new Wrapper(impl)
}
