package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait FilterRuleName {
  def unwrap: software.amazon.awssdk.services.s3.model.FilterRuleName
}
object FilterRuleName {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.FilterRuleName
  ): io.github.vigoo.zioaws.s3.model.FilterRuleName = value match {
    case software.amazon.awssdk.services.s3.model.FilterRuleName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.FilterRuleName.PREFIX =>
      val r = prefix
      r
    case software.amazon.awssdk.services.s3.model.FilterRuleName.SUFFIX =>
      val r = suffix
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.FilterRuleName {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FilterRuleName =
      software.amazon.awssdk.services.s3.model.FilterRuleName.UNKNOWN_TO_SDK_VERSION
  }
  case object prefix extends io.github.vigoo.zioaws.s3.model.FilterRuleName {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FilterRuleName =
      software.amazon.awssdk.services.s3.model.FilterRuleName.PREFIX
  }
  case object suffix extends io.github.vigoo.zioaws.s3.model.FilterRuleName {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.FilterRuleName =
      software.amazon.awssdk.services.s3.model.FilterRuleName.SUFFIX
  }
}
