package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketAccelerateConfigurationResponse(
    status: Option[io.github.vigoo.zioaws.s3.model.BucketAccelerateStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse = {
    import GetBucketAccelerateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketAccelerateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse(
        statusValue.map(value => value)
      )
    def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketAccelerateStatus]
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketAccelerateStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly {
    override def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketAccelerateStatus] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.BucketAccelerateStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
