package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketAclResponse(
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None,
    grants: Option[Iterable[io.github.vigoo.zioaws.s3.model.Grant]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAclResponse = {
    import GetBucketAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAclResponse
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.wrap(buildAwsValue())
}
object GetBucketAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketAclResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketAclResponse(
        ownerValue.map(value => value.editable),
        grantsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]]
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
    def grants: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Grant.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grantsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly {
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
    override def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Grant.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketAclResponse.ReadOnly =
    new Wrapper(impl)
}
