package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  AnalyticsId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketAnalyticsConfigurationRequest(
    bucket: BucketName,
    id: AnalyticsId,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest = {
    import GetBucketAnalyticsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketAnalyticsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest(
        bucketValue,
        idValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: AnalyticsId
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(idValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: AnalyticsId = impl.id(): AnalyticsId
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
