package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketAnalyticsConfigurationResponse(
    analyticsConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse = {
    import GetBucketAnalyticsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
      .builder()
      .optionallyWith(
        analyticsConfiguration.map(value => value.buildAwsValue())
      )(_.analyticsConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketAnalyticsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse(
        analyticsConfigurationValue.map(value => value.editable)
      )
    def analyticsConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    ]
    def analyticsConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "analyticsConfiguration",
      analyticsConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly {
    override def analyticsConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    ] = scala
      .Option(impl.analyticsConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketAnalyticsConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
