package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketCorsResponse(
    corsRules: Option[Iterable[io.github.vigoo.zioaws.s3.model.CORSRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketCorsResponse = {
    import GetBucketCorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
      .builder()
      .optionallyWith(
        corsRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.corsRules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.wrap(buildAwsValue())
}
object GetBucketCorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse(
        corsRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def corsRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly]]
    def corsRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly
    ]] = AwsError.unwrapOptionField("corsRules", corsRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly {
    override def corsRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly]] =
      scala
        .Option(impl.corsRules())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CORSRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketCorsResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketCorsResponse.ReadOnly =
    new Wrapper(impl)
}
