package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketEncryptionResponse(
    serverSideEncryptionConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse = {
    import GetBucketEncryptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
      .builder()
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse
      .wrap(buildAwsValue())
}
object GetBucketEncryptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse(
        serverSideEncryptionConfigurationValue.map(value => value.editable)
      )
    def serverSideEncryptionConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def serverSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly {
    override def serverSideEncryptionConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.serverSideEncryptionConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketEncryptionResponse.ReadOnly =
    new Wrapper(impl)
}
