package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketIntelligentTieringConfigurationResponse(
    intelligentTieringConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse = {
    import GetBucketIntelligentTieringConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
      .builder()
      .optionallyWith(
        intelligentTieringConfiguration.map(value => value.buildAwsValue())
      )(_.intelligentTieringConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketIntelligentTieringConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse =
      io.github.vigoo.zioaws.s3.model
        .GetBucketIntelligentTieringConfigurationResponse(
          intelligentTieringConfigurationValue.map(value => value.editable)
        )
    def intelligentTieringConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ]
    def intelligentTieringConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intelligentTieringConfiguration",
      intelligentTieringConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly {
    override def intelligentTieringConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ] = scala
      .Option(impl.intelligentTieringConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketIntelligentTieringConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
