package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketInventoryConfigurationResponse(
    inventoryConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse = {
    import GetBucketInventoryConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
      .builder()
      .optionallyWith(
        inventoryConfiguration.map(value => value.buildAwsValue())
      )(_.inventoryConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketInventoryConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse(
        inventoryConfigurationValue.map(value => value.editable)
      )
    def inventoryConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    ]
    def inventoryConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inventoryConfiguration",
      inventoryConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly {
    override def inventoryConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    ] = scala
      .Option(impl.inventoryConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.InventoryConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketInventoryConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
