package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketLifecycleConfigurationResponse(
    rules: Option[Iterable[io.github.vigoo.zioaws.s3.model.LifecycleRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse = {
    import GetBucketLifecycleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketLifecycleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse(
        rulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def rulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly]]
    def rules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly {
    override def rulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.LifecycleRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
