package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketLocationRequest(
    bucket: BucketName,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLocationRequest = {
    import GetBucketLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLocationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest
      .wrap(buildAwsValue())
}
object GetBucketLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest =
      io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest(
        bucketValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLocationRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLocationRequest
  ): io.github.vigoo.zioaws.s3.model.GetBucketLocationRequest.ReadOnly =
    new Wrapper(impl)
}
