package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketLoggingResponse(
    loggingEnabled: Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse = {
    import GetBucketLoggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
      .builder()
      .optionallyWith(loggingEnabled.map(value => value.buildAwsValue()))(
        _.loggingEnabled
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse
      .wrap(buildAwsValue())
}
object GetBucketLoggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse(
        loggingEnabledValue.map(value => value.editable)
      )
    def loggingEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly]
    def loggingEnabled: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("loggingEnabled", loggingEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly {
    override def loggingEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly] =
      scala
        .Option(impl.loggingEnabled())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.LoggingEnabled.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketLoggingResponse.ReadOnly =
    new Wrapper(impl)
}
