package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  MetricsId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketMetricsConfigurationRequest(
    bucket: BucketName,
    id: MetricsId,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest = {
    import GetBucketMetricsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketMetricsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest(
        bucketValue,
        idValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: MetricsId
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(idValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: MetricsId = impl.id(): MetricsId
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
