package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketMetricsConfigurationResponse(
    metricsConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse = {
    import GetBucketMetricsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
      .builder()
      .optionallyWith(metricsConfiguration.map(value => value.buildAwsValue()))(
        _.metricsConfiguration
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketMetricsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse(
        metricsConfigurationValue.map(value => value.editable)
      )
    def metricsConfigurationValue
        : Option[io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly]
    def metricsConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "metricsConfiguration",
      metricsConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly {
    override def metricsConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly
    ] = scala
      .Option(impl.metricsConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.MetricsConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketMetricsConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
