package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketOwnershipControlsResponse(
    ownershipControls: Option[
      io.github.vigoo.zioaws.s3.model.OwnershipControls
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse = {
    import GetBucketOwnershipControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
      .builder()
      .optionallyWith(ownershipControls.map(value => value.buildAwsValue()))(
        _.ownershipControls
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse
      .wrap(buildAwsValue())
}
object GetBucketOwnershipControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse(
        ownershipControlsValue.map(value => value.editable)
      )
    def ownershipControlsValue
        : Option[io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly]
    def ownershipControls: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly
    ] = AwsError.unwrapOptionField("ownershipControls", ownershipControlsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly {
    override def ownershipControlsValue
        : Option[io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly] =
      scala
        .Option(impl.ownershipControls())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.OwnershipControls.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketOwnershipControlsResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketOwnershipControlsResponse.ReadOnly =
    new Wrapper(impl)
}
