package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Policy
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketPolicyResponse(policy: Option[Policy] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse = {
    import GetBucketPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse
      .wrap(buildAwsValue())
}
object GetBucketPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse =
      io.github.vigoo.zioaws.s3.model
        .GetBucketPolicyResponse(policyValue.map(value => value))
    def policyValue: Option[Policy]
    def policy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly {
    override def policyValue: Option[Policy] =
      scala.Option(impl.policy()).map(value => value: Policy)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
