package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketPolicyStatusResponse(
    policyStatus: Option[io.github.vigoo.zioaws.s3.model.PolicyStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse = {
    import GetBucketPolicyStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
      .builder()
      .optionallyWith(policyStatus.map(value => value.buildAwsValue()))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse
      .wrap(buildAwsValue())
}
object GetBucketPolicyStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse(
        policyStatusValue.map(value => value.editable)
      )
    def policyStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly]
    def policyStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly
    ] = AwsError.unwrapOptionField("policyStatus", policyStatusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly {
    override def policyStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly] = scala
      .Option(impl.policyStatus())
      .map(value => io.github.vigoo.zioaws.s3.model.PolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketPolicyStatusResponse.ReadOnly =
    new Wrapper(impl)
}
