package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketReplicationResponse(
    replicationConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse = {
    import GetBucketReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
      .builder()
      .optionallyWith(
        replicationConfiguration.map(value => value.buildAwsValue())
      )(_.replicationConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse
      .wrap(buildAwsValue())
}
object GetBucketReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse(
        replicationConfigurationValue.map(value => value.editable)
      )
    def replicationConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly
    ]
    def replicationConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationConfiguration",
      replicationConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly {
    override def replicationConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly
    ] = scala
      .Option(impl.replicationConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketReplicationResponse.ReadOnly =
    new Wrapper(impl)
}
