package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketRequestPaymentResponse(
    payer: Option[io.github.vigoo.zioaws.s3.model.Payer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse = {
    import GetBucketRequestPaymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
      .builder()
      .optionallyWith(payer.map(value => value.unwrap))(_.payer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse
      .wrap(buildAwsValue())
}
object GetBucketRequestPaymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse =
      io.github.vigoo.zioaws.s3.model
        .GetBucketRequestPaymentResponse(payerValue.map(value => value))
    def payerValue: Option[io.github.vigoo.zioaws.s3.model.Payer]
    def payer: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Payer] =
      AwsError.unwrapOptionField("payer", payerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly {
    override def payerValue: Option[io.github.vigoo.zioaws.s3.model.Payer] =
      scala
        .Option(impl.payer())
        .map(value => io.github.vigoo.zioaws.s3.model.Payer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketRequestPaymentResponse.ReadOnly =
    new Wrapper(impl)
}
