package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketVersioningResponse(
    status: Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus] =
      None,
    mfaDelete: Option[io.github.vigoo.zioaws.s3.model.MFADeleteStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse = {
    import GetBucketVersioningResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse
      .wrap(buildAwsValue())
}
object GetBucketVersioningResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse(
        statusValue.map(value => value),
        mfaDeleteValue.map(value => value)
      )
    def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus]
    def mfaDeleteValue: Option[io.github.vigoo.zioaws.s3.model.MFADeleteStatus]
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketVersioningStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def mfaDelete
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.MFADeleteStatus] =
      AwsError.unwrapOptionField("mfaDelete", mfaDeleteValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly {
    override def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketVersioningStatus] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.BucketVersioningStatus.wrap(value)
      )
    override def mfaDeleteValue
        : Option[io.github.vigoo.zioaws.s3.model.MFADeleteStatus] = scala
      .Option(impl.mfaDelete())
      .map(value => io.github.vigoo.zioaws.s3.model.MFADeleteStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketVersioningResponse.ReadOnly =
    new Wrapper(impl)
}
