package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBucketWebsiteResponse(
    redirectAllRequestsTo: Option[
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo
    ] = None,
    indexDocument: Option[io.github.vigoo.zioaws.s3.model.IndexDocument] = None,
    errorDocument: Option[io.github.vigoo.zioaws.s3.model.ErrorDocument] = None,
    routingRules: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.RoutingRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse = {
    import GetBucketWebsiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
      .builder()
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse
      .wrap(buildAwsValue())
}
object GetBucketWebsiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse =
      io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse(
        redirectAllRequestsToValue.map(value => value.editable),
        indexDocumentValue.map(value => value.editable),
        errorDocumentValue.map(value => value.editable),
        routingRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def redirectAllRequestsToValue
        : Option[io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def indexDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly]
    def errorDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly]
    def routingRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly]]
    def redirectAllRequestsTo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redirectAllRequestsTo",
      redirectAllRequestsToValue
    )
    def indexDocument: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly
    ] = AwsError.unwrapOptionField("indexDocument", indexDocumentValue)
    def errorDocument: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly
    ] = AwsError.unwrapOptionField("errorDocument", errorDocumentValue)
    def routingRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly
    ]] = AwsError.unwrapOptionField("routingRules", routingRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly {
    override def redirectAllRequestsToValue: Option[
      io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly
    ] = scala
      .Option(impl.redirectAllRequestsTo())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.wrap(value)
      )
    override def indexDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.IndexDocument.ReadOnly] = scala
      .Option(impl.indexDocument())
      .map(value => io.github.vigoo.zioaws.s3.model.IndexDocument.wrap(value))
    override def errorDocumentValue
        : Option[io.github.vigoo.zioaws.s3.model.ErrorDocument.ReadOnly] = scala
      .Option(impl.errorDocument())
      .map(value => io.github.vigoo.zioaws.s3.model.ErrorDocument.wrap(value))
    override def routingRulesValue
        : Option[List[io.github.vigoo.zioaws.s3.model.RoutingRule.ReadOnly]] =
      scala
        .Option(impl.routingRules())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.RoutingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ): io.github.vigoo.zioaws.s3.model.GetBucketWebsiteResponse.ReadOnly =
    new Wrapper(impl)
}
