package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectAclResponse(
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None,
    grants: Option[Iterable[io.github.vigoo.zioaws.s3.model.Grant]] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAclResponse = {
    import GetObjectAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAclResponse
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.wrap(buildAwsValue())
}
object GetObjectAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectAclResponse =
      io.github.vigoo.zioaws.s3.model.GetObjectAclResponse(
        ownerValue.map(value => value.editable),
        grantsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        requestChargedValue.map(value => value)
      )
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
    def grants: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Grant.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grantsValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly {
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
    override def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Grant.wrap(item)
        }.toList
      )
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectAclResponse.ReadOnly =
    new Wrapper(impl)
}
