package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  MaxParts,
  PartsCount,
  NextPartNumberMarker,
  PartNumberMarker,
  IsTruncated
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectAttributesParts(
    totalPartsCount: Option[PartsCount] = None,
    partNumberMarker: Option[PartNumberMarker] = None,
    nextPartNumberMarker: Option[NextPartNumberMarker] = None,
    maxParts: Option[MaxParts] = None,
    isTruncated: Option[IsTruncated] = None,
    parts: Option[Iterable[io.github.vigoo.zioaws.s3.model.ObjectPart]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesParts = {
    import GetObjectAttributesParts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
      .builder()
      .optionallyWith(totalPartsCount.map(value => value: Integer))(
        _.totalPartsCount
      )
      .optionallyWith(partNumberMarker.map(value => value: Integer))(
        _.partNumberMarker
      )
      .optionallyWith(nextPartNumberMarker.map(value => value: Integer))(
        _.nextPartNumberMarker
      )
      .optionallyWith(maxParts.map(value => value: Integer))(_.maxParts)
      .optionallyWith(isTruncated.map(value => value: java.lang.Boolean))(
        _.isTruncated
      )
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts
      .wrap(buildAwsValue())
}
object GetObjectAttributesParts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts =
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts(
        totalPartsCountValue.map(value => value),
        partNumberMarkerValue.map(value => value),
        nextPartNumberMarkerValue.map(value => value),
        maxPartsValue.map(value => value),
        isTruncatedValue.map(value => value),
        partsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def totalPartsCountValue: Option[PartsCount]
    def partNumberMarkerValue: Option[PartNumberMarker]
    def nextPartNumberMarkerValue: Option[NextPartNumberMarker]
    def maxPartsValue: Option[MaxParts]
    def isTruncatedValue: Option[IsTruncated]
    def partsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ObjectPart.ReadOnly]]
    def totalPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("totalPartsCount", totalPartsCountValue)
    def partNumberMarker: ZIO[Any, AwsError, PartNumberMarker] =
      AwsError.unwrapOptionField("partNumberMarker", partNumberMarkerValue)
    def nextPartNumberMarker: ZIO[Any, AwsError, NextPartNumberMarker] =
      AwsError.unwrapOptionField(
        "nextPartNumberMarker",
        nextPartNumberMarkerValue
      )
    def maxParts: ZIO[Any, AwsError, MaxParts] =
      AwsError.unwrapOptionField("maxParts", maxPartsValue)
    def isTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncatedValue)
    def parts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.ObjectPart.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", partsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly {
    override def totalPartsCountValue: Option[PartsCount] =
      scala.Option(impl.totalPartsCount()).map(value => value: PartsCount)
    override def partNumberMarkerValue: Option[PartNumberMarker] = scala
      .Option(impl.partNumberMarker())
      .map(value => value: PartNumberMarker)
    override def nextPartNumberMarkerValue: Option[NextPartNumberMarker] = scala
      .Option(impl.nextPartNumberMarker())
      .map(value => value: NextPartNumberMarker)
    override def maxPartsValue: Option[MaxParts] =
      scala.Option(impl.maxParts()).map(value => value: MaxParts)
    override def isTruncatedValue: Option[IsTruncated] =
      scala.Option(impl.isTruncated()).map(value => value: IsTruncated)
    override def partsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ObjectPart.ReadOnly]] =
      scala
        .Option(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.ObjectPart.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesParts
  ): io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly =
    new Wrapper(impl)
}
