package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ETag,
  DeleteMarker,
  LastModified,
  ObjectVersionId,
  ObjectSize
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectAttributesResponse(
    deleteMarker: Option[DeleteMarker] = None,
    lastModified: Option[LastModified] = None,
    versionId: Option[ObjectVersionId] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    eTag: Option[ETag] = None,
    checksum: Option[io.github.vigoo.zioaws.s3.model.Checksum] = None,
    objectParts: Option[
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts
    ] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    objectSize: Option[ObjectSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse = {
    import GetObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
      .builder()
      .optionallyWith(deleteMarker.map(value => value: java.lang.Boolean))(
        _.deleteMarker
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(checksum.map(value => value.buildAwsValue()))(_.checksum)
      .optionallyWith(objectParts.map(value => value.buildAwsValue()))(
        _.objectParts
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(objectSize.map(value => value: java.lang.Long))(
        _.objectSize
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse
      .wrap(buildAwsValue())
}
object GetObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse =
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse(
        deleteMarkerValue.map(value => value),
        lastModifiedValue.map(value => value),
        versionIdValue.map(value => value),
        requestChargedValue.map(value => value),
        eTagValue.map(value => value),
        checksumValue.map(value => value.editable),
        objectPartsValue.map(value => value.editable),
        storageClassValue.map(value => value),
        objectSizeValue.map(value => value)
      )
    def deleteMarkerValue: Option[DeleteMarker]
    def lastModifiedValue: Option[LastModified]
    def versionIdValue: Option[ObjectVersionId]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def eTagValue: Option[ETag]
    def checksumValue: Option[io.github.vigoo.zioaws.s3.model.Checksum.ReadOnly]
    def objectPartsValue: Option[
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly
    ]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def objectSizeValue: Option[ObjectSize]
    def deleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarkerValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def checksum: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.Checksum.ReadOnly
    ] = AwsError.unwrapOptionField("checksum", checksumValue)
    def objectParts: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly
    ] = AwsError.unwrapOptionField("objectParts", objectPartsValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def objectSize: ZIO[Any, AwsError, ObjectSize] =
      AwsError.unwrapOptionField("objectSize", objectSizeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly {
    override def deleteMarkerValue: Option[DeleteMarker] =
      scala.Option(impl.deleteMarker()).map(value => value: DeleteMarker)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def checksumValue
        : Option[io.github.vigoo.zioaws.s3.model.Checksum.ReadOnly] = scala
      .Option(impl.checksum())
      .map(value => io.github.vigoo.zioaws.s3.model.Checksum.wrap(value))
    override def objectPartsValue: Option[
      io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.ReadOnly
    ] = scala
      .Option(impl.objectParts())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.GetObjectAttributesParts.wrap(value)
      )
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def objectSizeValue: Option[ObjectSize] =
      scala.Option(impl.objectSize()).map(value => value: ObjectSize)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
