package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectLegalHoldResponse(
    legalHold: Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse = {
    import GetObjectLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
      .builder()
      .optionallyWith(legalHold.map(value => value.buildAwsValue()))(
        _.legalHold
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse
      .wrap(buildAwsValue())
}
object GetObjectLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse =
      io.github.vigoo.zioaws.s3.model
        .GetObjectLegalHoldResponse(legalHoldValue.map(value => value.editable))
    def legalHoldValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly]
    def legalHold: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly
    ] = AwsError.unwrapOptionField("legalHold", legalHoldValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly {
    override def legalHoldValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly] =
      scala
        .Option(impl.legalHold())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectLegalHoldResponse.ReadOnly =
    new Wrapper(impl)
}
