package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectLockConfigurationResponse(
    objectLockConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse = {
    import GetObjectLockConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
      .builder()
      .optionallyWith(
        objectLockConfiguration.map(value => value.buildAwsValue())
      )(_.objectLockConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse
      .wrap(buildAwsValue())
}
object GetObjectLockConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse =
      io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse(
        objectLockConfigurationValue.map(value => value.editable)
      )
    def objectLockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ]
    def objectLockConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectLockConfiguration",
      objectLockConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly {
    override def objectLockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = scala
      .Option(impl.objectLockConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectLockConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
