package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  ResponseContentLanguage,
  AccountId,
  ResponseExpires,
  ResponseContentType,
  SSECustomerAlgorithm,
  IfModifiedSince,
  IfNoneMatch,
  IfMatch,
  SSECustomerKeyMD5,
  ObjectKey,
  ResponseContentEncoding,
  BucketName,
  IfUnmodifiedSince,
  ResponseContentDisposition,
  ResponseCacheControl,
  ObjectVersionId,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetObjectRequest(
    bucket: BucketName,
    ifMatch: Option[IfMatch] = None,
    ifModifiedSince: Option[IfModifiedSince] = None,
    ifNoneMatch: Option[IfNoneMatch] = None,
    ifUnmodifiedSince: Option[IfUnmodifiedSince] = None,
    key: ObjectKey,
    range: Option[io.github.vigoo.zioaws.s3.model.primitives.Range] = None,
    responseCacheControl: Option[ResponseCacheControl] = None,
    responseContentDisposition: Option[ResponseContentDisposition] = None,
    responseContentEncoding: Option[ResponseContentEncoding] = None,
    responseContentLanguage: Option[ResponseContentLanguage] = None,
    responseContentType: Option[ResponseContentType] = None,
    responseExpires: Option[ResponseExpires] = None,
    versionId: Option[ObjectVersionId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    partNumber: Option[PartNumber] = None,
    expectedBucketOwner: Option[AccountId] = None,
    checksumMode: Option[io.github.vigoo.zioaws.s3.model.ChecksumMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectRequest = {
    import GetObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .optionallyWith(ifModifiedSince.map(value => value: Instant))(
        _.ifModifiedSince
      )
      .optionallyWith(ifNoneMatch.map(value => value: java.lang.String))(
        _.ifNoneMatch
      )
      .optionallyWith(ifUnmodifiedSince.map(value => value: Instant))(
        _.ifUnmodifiedSince
      )
      .key(key: java.lang.String)
      .optionallyWith(range.map(value => value: java.lang.String))(_.range)
      .optionallyWith(
        responseCacheControl.map(value => value: java.lang.String)
      )(_.responseCacheControl)
      .optionallyWith(
        responseContentDisposition.map(value => value: java.lang.String)
      )(_.responseContentDisposition)
      .optionallyWith(
        responseContentEncoding.map(value => value: java.lang.String)
      )(_.responseContentEncoding)
      .optionallyWith(
        responseContentLanguage.map(value => value: java.lang.String)
      )(_.responseContentLanguage)
      .optionallyWith(
        responseContentType.map(value => value: java.lang.String)
      )(_.responseContentType)
      .optionallyWith(responseExpires.map(value => value: Instant))(
        _.responseExpires
      )
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(partNumber.map(value => value: Integer))(_.partNumber)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(checksumMode.map(value => value.unwrap))(_.checksumMode)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.GetObjectRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectRequest.wrap(buildAwsValue())
}
object GetObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectRequest =
      io.github.vigoo.zioaws.s3.model.GetObjectRequest(
        bucketValue,
        ifMatchValue.map(value => value),
        ifModifiedSinceValue.map(value => value),
        ifNoneMatchValue.map(value => value),
        ifUnmodifiedSinceValue.map(value => value),
        keyValue,
        rangeValue.map(value => value),
        responseCacheControlValue.map(value => value),
        responseContentDispositionValue.map(value => value),
        responseContentEncodingValue.map(value => value),
        responseContentLanguageValue.map(value => value),
        responseContentTypeValue.map(value => value),
        responseExpiresValue.map(value => value),
        versionIdValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        requestPayerValue.map(value => value),
        partNumberValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        checksumModeValue.map(value => value)
      )
    def bucketValue: BucketName
    def ifMatchValue: Option[IfMatch]
    def ifModifiedSinceValue: Option[IfModifiedSince]
    def ifNoneMatchValue: Option[IfNoneMatch]
    def ifUnmodifiedSinceValue: Option[IfUnmodifiedSince]
    def keyValue: ObjectKey
    def rangeValue: Option[io.github.vigoo.zioaws.s3.model.primitives.Range]
    def responseCacheControlValue: Option[ResponseCacheControl]
    def responseContentDispositionValue: Option[ResponseContentDisposition]
    def responseContentEncodingValue: Option[ResponseContentEncoding]
    def responseContentLanguageValue: Option[ResponseContentLanguage]
    def responseContentTypeValue: Option[ResponseContentType]
    def responseExpiresValue: Option[ResponseExpires]
    def versionIdValue: Option[ObjectVersionId]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def partNumberValue: Option[PartNumber]
    def expectedBucketOwnerValue: Option[AccountId]
    def checksumModeValue: Option[io.github.vigoo.zioaws.s3.model.ChecksumMode]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def ifMatch: ZIO[Any, AwsError, IfMatch] =
      AwsError.unwrapOptionField("ifMatch", ifMatchValue)
    def ifModifiedSince: ZIO[Any, AwsError, IfModifiedSince] =
      AwsError.unwrapOptionField("ifModifiedSince", ifModifiedSinceValue)
    def ifNoneMatch: ZIO[Any, AwsError, IfNoneMatch] =
      AwsError.unwrapOptionField("ifNoneMatch", ifNoneMatchValue)
    def ifUnmodifiedSince: ZIO[Any, AwsError, IfUnmodifiedSince] =
      AwsError.unwrapOptionField("ifUnmodifiedSince", ifUnmodifiedSinceValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def range
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.primitives.Range] =
      AwsError.unwrapOptionField("range", rangeValue)
    def responseCacheControl: ZIO[Any, AwsError, ResponseCacheControl] =
      AwsError.unwrapOptionField(
        "responseCacheControl",
        responseCacheControlValue
      )
    def responseContentDisposition
        : ZIO[Any, AwsError, ResponseContentDisposition] =
      AwsError.unwrapOptionField(
        "responseContentDisposition",
        responseContentDispositionValue
      )
    def responseContentEncoding: ZIO[Any, AwsError, ResponseContentEncoding] =
      AwsError.unwrapOptionField(
        "responseContentEncoding",
        responseContentEncodingValue
      )
    def responseContentLanguage: ZIO[Any, AwsError, ResponseContentLanguage] =
      AwsError.unwrapOptionField(
        "responseContentLanguage",
        responseContentLanguageValue
      )
    def responseContentType: ZIO[Any, AwsError, ResponseContentType] = AwsError
      .unwrapOptionField("responseContentType", responseContentTypeValue)
    def responseExpires: ZIO[Any, AwsError, ResponseExpires] =
      AwsError.unwrapOptionField("responseExpires", responseExpiresValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def partNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumberValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def checksumMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ChecksumMode] =
      AwsError.unwrapOptionField("checksumMode", checksumModeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def ifMatchValue: Option[IfMatch] =
      scala.Option(impl.ifMatch()).map(value => value: IfMatch)
    override def ifModifiedSinceValue: Option[IfModifiedSince] =
      scala.Option(impl.ifModifiedSince()).map(value => value: IfModifiedSince)
    override def ifNoneMatchValue: Option[IfNoneMatch] =
      scala.Option(impl.ifNoneMatch()).map(value => value: IfNoneMatch)
    override def ifUnmodifiedSinceValue: Option[IfUnmodifiedSince] = scala
      .Option(impl.ifUnmodifiedSince())
      .map(value => value: IfUnmodifiedSince)
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def rangeValue
        : Option[io.github.vigoo.zioaws.s3.model.primitives.Range] = scala
      .Option(impl.range())
      .map(value => value: io.github.vigoo.zioaws.s3.model.primitives.Range)
    override def responseCacheControlValue: Option[ResponseCacheControl] = scala
      .Option(impl.responseCacheControl())
      .map(value => value: ResponseCacheControl)
    override def responseContentDispositionValue
        : Option[ResponseContentDisposition] = scala
      .Option(impl.responseContentDisposition())
      .map(value => value: ResponseContentDisposition)
    override def responseContentEncodingValue: Option[ResponseContentEncoding] =
      scala
        .Option(impl.responseContentEncoding())
        .map(value => value: ResponseContentEncoding)
    override def responseContentLanguageValue: Option[ResponseContentLanguage] =
      scala
        .Option(impl.responseContentLanguage())
        .map(value => value: ResponseContentLanguage)
    override def responseContentTypeValue: Option[ResponseContentType] = scala
      .Option(impl.responseContentType())
      .map(value => value: ResponseContentType)
    override def responseExpiresValue: Option[ResponseExpires] =
      scala.Option(impl.responseExpires()).map(value => value: ResponseExpires)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def partNumberValue: Option[PartNumber] =
      scala.Option(impl.partNumber()).map(value => value: PartNumber)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def checksumModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumMode] = scala
      .Option(impl.checksumMode())
      .map(value => io.github.vigoo.zioaws.s3.model.ChecksumMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRequest
  ): io.github.vigoo.zioaws.s3.model.GetObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
