package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectRetentionResponse(
    retention: Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse = {
    import GetObjectRetentionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
      .builder()
      .optionallyWith(retention.map(value => value.buildAwsValue()))(
        _.retention
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse
      .wrap(buildAwsValue())
}
object GetObjectRetentionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse =
      io.github.vigoo.zioaws.s3.model
        .GetObjectRetentionResponse(retentionValue.map(value => value.editable))
    def retentionValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly]
    def retention: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly
    ] = AwsError.unwrapOptionField("retention", retentionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly {
    override def retentionValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly] =
      scala
        .Option(impl.retention())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockRetention.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectRetentionResponse.ReadOnly =
    new Wrapper(impl)
}
