package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ObjectVersionId,
  ObjectKey,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectTaggingRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    expectedBucketOwner: Option[AccountId] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest = {
    import GetObjectTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest
      .wrap(buildAwsValue())
}
object GetObjectTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest =
      io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest(
        bucketValue,
        keyValue,
        versionIdValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        requestPayerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def versionIdValue: Option[ObjectVersionId]
    def expectedBucketOwnerValue: Option[AccountId]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest
  ): io.github.vigoo.zioaws.s3.model.GetObjectTaggingRequest.ReadOnly =
    new Wrapper(impl)
}
