package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.ObjectVersionId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetObjectTaggingResponse(
    versionId: Option[ObjectVersionId] = None,
    tagSet: Iterable[io.github.vigoo.zioaws.s3.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse = {
    import GetObjectTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
      .builder()
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .tagSet(tagSet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse
      .wrap(buildAwsValue())
}
object GetObjectTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse =
      io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse(
        versionIdValue.map(value => value),
        tagSetValue.map { item =>
          item.editable
        }
      )
    def versionIdValue: Option[ObjectVersionId]
    def tagSetValue: List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def tagSet: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagSetValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ) extends io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly {
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def tagSetValue
        : List[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = impl
      .tagSet()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse
  ): io.github.vigoo.zioaws.s3.model.GetObjectTaggingResponse.ReadOnly =
    new Wrapper(impl)
}
